	import "./botones.js";
	import {wcf_allInstances} from "./wcfManage.js";

	class site_card extends HTMLElement {
		static attributes = {};
		urlBase = ".";
		
		hasShadow;
		instanceVariantDefaults = {"COMP-BOTONES":{"variant":"1","children":{}},"COMP-BOTONES-1":{"variant":"1","children":{}},"COMP-BOTONES-2":{"variant":"1","children":{}}};
		emptySvg = 'data:image/svg+xml;charset=utf-8, <svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg"><rect width="100%" height="100%" style="fill-opacity:0;" /></svg>';
		defaultTexts = "off";
		defaultImages = "off";

		constructor() {
			super();
			this.urlBase = wcf_allInstances.actualUrlBase("./js/site-card.js");
		}

		replaceDefaults(newDefaults) {
			this.instanceVariantDefaults = newDefaults;
		}

		connectedCallback() {
			let compId;
			let shadow;

			if (this.hasAttribute("defaultTexts")) {
				this.defaultTexts = this.getAttribute("defaultTexts");
			}
			if (this.hasAttribute("defaultImages")) {
				this.defaultImages = this.getAttribute("defaultImages");
			}

			if (this.getRootNode().host) {
				this.hasShadow = false;
			} else {
				this.hasShadow = true;
				shadow = this.attachShadow({ mode: "open", delegatesFocus: true});
			}

			/* add the component to the global component list */
			const tagIdOri = this.getAttribute("id");
			let tagIdValue;
			if (tagIdOri) {
				tagIdValue = wcf_allInstances.getUniqueInstanceId(tagIdOri);
			} else {
				tagIdValue = wcf_allInstances.getUniqueInstanceId("compInstance");
			}
			const tagId = tagIdValue;
			wcf_allInstances.addInstance(tagId, this, this.hasShadow);
			wcf_allInstances.addProp(tagId, "oriComp", "site-card");
			wcf_allInstances.allCompsIds[tagId] = {};
			this.setAttribute("id",tagId);


			/* Add the attributes mutation observer */
			this.mutationObserver = new MutationObserver(this.mutationObserverCallback);
			this.mutationObserver.observe(this, {attributes: true, attributeOldValue: true});

			const site_card = document.createElement("div");
			site_card.setAttribute("data-wcfid", "site_card");
			site_card.setAttribute("original-id", "63:152");
			site_card.setAttribute("data-name", "site-card");
			site_card.setAttribute("data-component-id", "site-card");
			site_card.setAttribute("class", "css-site_card site_card");
			site_card.setAttribute("data-wcfid", "site_card");
			wcf_allInstances.allCompsIds[tagId]["site_card"] = site_card;
			if (this.hasShadow) {
				shadow.appendChild(site_card);
			} else {
				this.appendChild(site_card);
			}

			if (this.hasShadow) {
				const cssReset = document.createElement("link");
				cssReset.setAttribute("rel", "stylesheet");
				cssReset.setAttribute("href", this.urlBase+"/css/reset.css");
				shadow.appendChild(cssReset);

			}
			/* if component has private styles, they go here */
			let cssText =' .site_card {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; border:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; box-sizing:border-box; display:flex; width:100%; height:173px; flex-flow:row; gap:11px; justify-content:center; align-items:center; padding:10px 12px 10px 24px; color:rgb(255, 255, 255); background-color:rgb(255, 255, 255); border-radius:6px; } .vector_rectangle_1 {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; color:rgb(217, 217, 217); } .frame_102 {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; border:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; box-sizing:border-box; display:flex; width:fit-content; height:100%; flex-flow:column; gap:16px; justify-content:center; padding:16px 8px; } .frame_101 {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; box-sizing:border-box; display:flex; width:100%; height:fit-content; flex-flow:column; gap:8px; justify-content:center; } .frame_99 {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; box-sizing:border-box; display:flex; width:fit-content; height:fit-content; flex-flow:row; gap:8px; align-items:center; } .s22_november {min-height:1.05703422em; font-style:normal; font-variant:normal; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; vertical-align:baseline; background:transparent; color:rgb(61, 61, 61); font-family:Inter; font-weight:400; font-size:20px; text-align:left; letter-spacing:0px; line-height:24px; } .vector_rectangle_3 {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; color:rgb(61, 61, 61); } .design {min-height:1.05703422em; font-style:normal; font-variant:normal; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; vertical-align:baseline; background:transparent; color:rgb(61, 61, 61); font-family:Inter; font-weight:400; font-size:20px; text-align:left; letter-spacing:0px; line-height:24px; } .top_10_product_design_ideas {min-height:1.05703422em; font-style:normal; font-variant:normal; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; vertical-align:baseline; background:transparent; color:rgb(0, 0, 0); font-family:Inter; font-weight:600; font-size:20px; text-align:left; letter-spacing:0px; line-height:24px; } .frame_100 {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; box-sizing:border-box; display:flex; width:100%; height:fit-content; flex-flow:row; gap:8px; align-items:center; } blockquote::before, blockquote::after, q::before, q::after {content: none;} blockquote::before, blockquote::after, q::before, q::after {content: none;} ';
			const cssBkgImages = [...cssText.matchAll(/\.([^ {}]+) *{[^{]*background-image:url\("(.*?)"/g)];
			if (this.defaultImages != "on") {
				for (let i = 0; i < cssBkgImages.length; i++) {
					cssText = cssText.replace("background-image:url(\""+cssBkgImages[i][2]+"\")", "background-image:none");
				}
			}

			if (typeof switchesCssText != "undefined") {
				cssText += switchesCssText;
			}
			let style = document.createElement("style");
			style.type = "text/css";
			style.textContent = cssText;
			if (this.hasShadow) {
				shadow.appendChild(style);
			} else {
				this.appendChild(style);
			}
			/* Fonts need to be added to document head also in order to work properly */
			let sheet = window.document.styleSheets[0];
			if (typeof sheet == "undefined") {
				sheet = new CSSStyleSheet();
				document.adoptedStyleSheets = [sheet];
			}
			let rule;
			rule = '@font-face {font-family: Inter; font-style: normal; font-weight: 400; src: url('+this.urlBase+'/fonts/Inter-Regular.ttf);}';
			if (!wcf_allInstances.isFontLoaded(rule)) {
				sheet.insertRule(rule,sheet.cssRules.length);
			}
			rule = '@font-face {font-family: Inter; font-style: normal; font-weight: 500; src: url('+this.urlBase+'/fonts/Inter-Medium.ttf);}';
			if (!wcf_allInstances.isFontLoaded(rule)) {
				sheet.insertRule(rule,sheet.cssRules.length);
			}
			rule = '@font-face {font-family: Inter; font-style: normal; font-weight: 600; src: url('+this.urlBase+'/fonts/Inter-SemiBold.ttf);}';
			if (!wcf_allInstances.isFontLoaded(rule)) {
				sheet.insertRule(rule,sheet.cssRules.length);
			}



			const vector_rectangle_1 = document.createElement("img");
			if (this.defaultImages == "on") {
				vector_rectangle_1.setAttribute("src", this.urlBase+"/img/vectors6442.svg");
			} else {
				vector_rectangle_1.setAttribute("src", this.emptySvg);
			}
			vector_rectangle_1.setAttribute("width", "235px");
			vector_rectangle_1.setAttribute("height", "123px");
			vector_rectangle_1.setAttribute("data-wcfid", "vector_rectangle_1");
			vector_rectangle_1.setAttribute("original-id", "64:42");
			vector_rectangle_1.setAttribute("data-name", "vector-rectangle-1");
			vector_rectangle_1.setAttribute("class", "css-Vector_Rectangle_1 vector_rectangle_1");
			vector_rectangle_1.setAttribute("data-wcfid", "vector_rectangle_1");
			wcf_allInstances.allCompsIds[tagId]["vector_rectangle_1"] = vector_rectangle_1;


			/* get the parameter if exists */
			var vector_rectangle_1_src = this.getAttribute("vector_rectangle_1_src");
			if (vector_rectangle_1_src) {
				vector_rectangle_1.setAttribute("src",vector_rectangle_1_src);
			}

			/* Register the attribute for the observer */
			wcf_allInstances.attrObserveRegister(tagId,"vector_rectangle_1_src", {"elem": vector_rectangle_1, "type":"img", "wcfAttr": true}, false)

			site_card.appendChild(vector_rectangle_1);

			const frame_102 = document.createElement("div");
			frame_102.setAttribute("data-wcfid", "frame_102");
			frame_102.setAttribute("original-id", "63:135");
			frame_102.setAttribute("data-name", "frame-102");
			frame_102.setAttribute("class", "css-Frame_102 frame_102");
			frame_102.setAttribute("data-wcfid", "frame_102");
			wcf_allInstances.allCompsIds[tagId]["frame_102"] = frame_102;
			site_card.appendChild(frame_102);

			const frame_101 = document.createElement("div");
			frame_101.setAttribute("data-wcfid", "frame_101");
			frame_101.setAttribute("original-id", "63:136");
			frame_101.setAttribute("data-name", "frame-101");
			frame_101.setAttribute("class", "css-Frame_101 frame_101");
			frame_101.setAttribute("data-wcfid", "frame_101");
			wcf_allInstances.allCompsIds[tagId]["frame_101"] = frame_101;
			frame_102.appendChild(frame_101);

			const frame_99 = document.createElement("div");
			frame_99.setAttribute("data-wcfid", "frame_99");
			frame_99.setAttribute("original-id", "63:137");
			frame_99.setAttribute("data-name", "frame-99");
			frame_99.setAttribute("class", "css-Frame_99 frame_99");
			frame_99.setAttribute("data-wcfid", "frame_99");
			wcf_allInstances.allCompsIds[tagId]["frame_99"] = frame_99;
			frame_101.appendChild(frame_99);

			const s22_november = document.createElement("p");
			s22_november.setAttribute("data-wcfid", "s22_november");
			s22_november.setAttribute("original-id", "63:138");
			s22_november.setAttribute("data-name", "s22-november");
			s22_november.setAttribute("class", "css-s_22_November s22_november");
			s22_november.setAttribute("data-wcfid", "s22_november");
			wcf_allInstances.allCompsIds[tagId]["s22_november"] = s22_november;


			/* get the parameter if exists */
			var s22_novembertext = this.getAttribute("s22_november");
			if (this.defaultTexts == "on") {
				s22_november.textContent = "22 November";
			} else {
				s22_november.textContent = " ";
			}
			if (this.hasAttribute("s22_november")) {
				s22_november.textContent = this.getAttribute("s22_november");
			}

			/* Register the attribute for the observer */
			wcf_allInstances.attrObserveRegister(tagId,"s22_november", {"elem": s22_november, "type":"p", "wcfAttr": true}, false)

			frame_99.appendChild(s22_november);

			const vector_rectangle_3 = document.createElement("img");
			if (this.defaultImages == "on") {
				vector_rectangle_3.setAttribute("src", this.urlBase+"/img/vectors6445.svg");
			} else {
				vector_rectangle_3.setAttribute("src", this.emptySvg);
			}
			vector_rectangle_3.setAttribute("width", "10px");
			vector_rectangle_3.setAttribute("height", "10px");
			vector_rectangle_3.setAttribute("data-wcfid", "vector_rectangle_3");
			vector_rectangle_3.setAttribute("original-id", "64:45");
			vector_rectangle_3.setAttribute("data-name", "vector-rectangle-3");
			vector_rectangle_3.setAttribute("class", "css-Vector_Rectangle_3 vector_rectangle_3");
			vector_rectangle_3.setAttribute("data-wcfid", "vector_rectangle_3");
			wcf_allInstances.allCompsIds[tagId]["vector_rectangle_3"] = vector_rectangle_3;


			/* get the parameter if exists */
			var vector_rectangle_3_src = this.getAttribute("vector_rectangle_3_src");
			if (vector_rectangle_3_src) {
				vector_rectangle_3.setAttribute("src",vector_rectangle_3_src);
			}

			/* Register the attribute for the observer */
			wcf_allInstances.attrObserveRegister(tagId,"vector_rectangle_3_src", {"elem": vector_rectangle_3, "type":"img", "wcfAttr": true}, false)

			frame_99.appendChild(vector_rectangle_3);

			const design = document.createElement("p");
			design.setAttribute("data-wcfid", "design");
			design.setAttribute("original-id", "63:140");
			design.setAttribute("data-name", "design");
			design.setAttribute("class", "css-Design design");
			design.setAttribute("data-wcfid", "design");
			wcf_allInstances.allCompsIds[tagId]["design"] = design;


			/* get the parameter if exists */
			var designtext = this.getAttribute("design");
			if (this.defaultTexts == "on") {
				design.textContent = "Design";
			} else {
				design.textContent = " ";
			}
			if (this.hasAttribute("design")) {
				design.textContent = this.getAttribute("design");
			}

			/* Register the attribute for the observer */
			wcf_allInstances.attrObserveRegister(tagId,"design", {"elem": design, "type":"p", "wcfAttr": true}, false)

			frame_99.appendChild(design);

			const top_10_product_design_ideas = document.createElement("p");
			top_10_product_design_ideas.setAttribute("data-wcfid", "top_10_product_design_ideas");
			top_10_product_design_ideas.setAttribute("original-id", "63:141");
			top_10_product_design_ideas.setAttribute("data-name", "top-10-product-design-ideas");
			top_10_product_design_ideas.setAttribute("class", "css-Top_10_product_design_ideas top_10_product_design_ideas");
			top_10_product_design_ideas.setAttribute("data-wcfid", "top_10_product_design_ideas");
			wcf_allInstances.allCompsIds[tagId]["top_10_product_design_ideas"] = top_10_product_design_ideas;


			/* get the parameter if exists */
			var top_10_product_design_ideastext = this.getAttribute("top_10_product_design_ideas");
			if (this.defaultTexts == "on") {
				top_10_product_design_ideas.textContent = "Top 10 product design ideas";
			} else {
				top_10_product_design_ideas.textContent = " ";
			}
			if (this.hasAttribute("top_10_product_design_ideas")) {
				top_10_product_design_ideas.textContent = this.getAttribute("top_10_product_design_ideas");
			}

			/* Register the attribute for the observer */
			wcf_allInstances.attrObserveRegister(tagId,"top_10_product_design_ideas", {"elem": top_10_product_design_ideas, "type":"p", "wcfAttr": true}, false)

			frame_101.appendChild(top_10_product_design_ideas);

			const frame_100 = document.createElement("div");
			frame_100.setAttribute("data-wcfid", "frame_100");
			frame_100.setAttribute("original-id", "63:142");
			frame_100.setAttribute("data-name", "frame-100");
			frame_100.setAttribute("class", "css-Frame_100 frame_100");
			frame_100.setAttribute("data-wcfid", "frame_100");
			wcf_allInstances.allCompsIds[tagId]["frame_100"] = frame_100;
			frame_102.appendChild(frame_100);

			/* instance of botones */
			let comp_botones;
			if (this.getAttribute("no-subcomps") != "true") {
				comp_botones = document.createElement("comp-botones");
				if (this.instanceVariantDefaults["COMP-BOTONES"]) {				// sets the default variant for childs
					comp_botones.addEventListener("load", () => {
						comp_botones.replaceDefaults(this.instanceVariantDefaults["COMP-BOTONES"]["children"]);
					});
				}
				compId = wcf_allInstances.getUniqueInstanceId(tagId+".botones");
				comp_botones.setAttribute("id",compId);
				comp_botones.setAttribute("data-wcfid","comp_botones");
				comp_botones.setAttribute("name","comp_botones");
				comp_botones.setAttribute("defaultTexts", this.defaultTexts);
				comp_botones.setAttribute("defaultImages", this.defaultImages);
				frame_100.appendChild(comp_botones);
			}


			/* instance of botones */
			let comp_botones_1;
			if (this.getAttribute("no-subcomps") != "true") {
				comp_botones_1 = document.createElement("comp-botones");
				if (this.instanceVariantDefaults["COMP-BOTONES"]) {				// sets the default variant for childs
					comp_botones_1.addEventListener("load", () => {
						comp_botones_1.replaceDefaults(this.instanceVariantDefaults["COMP-BOTONES"]["children"]);
					});
				}
				compId = wcf_allInstances.getUniqueInstanceId(tagId+".botones");
				comp_botones_1.setAttribute("id",compId);
				comp_botones_1.setAttribute("data-wcfid","comp_botones_1");
				comp_botones_1.setAttribute("name","comp_botones_1");
				comp_botones_1.setAttribute("defaultTexts", this.defaultTexts);
				comp_botones_1.setAttribute("defaultImages", this.defaultImages);
				frame_100.appendChild(comp_botones_1);
			}


			/* instance of botones */
			let comp_botones_2;
			if (this.getAttribute("no-subcomps") != "true") {
				comp_botones_2 = document.createElement("comp-botones");
				if (this.instanceVariantDefaults["COMP-BOTONES"]) {				// sets the default variant for childs
					comp_botones_2.addEventListener("load", () => {
						comp_botones_2.replaceDefaults(this.instanceVariantDefaults["COMP-BOTONES"]["children"]);
					});
				}
				compId = wcf_allInstances.getUniqueInstanceId(tagId+".botones");
				comp_botones_2.setAttribute("id",compId);
				comp_botones_2.setAttribute("data-wcfid","comp_botones_2");
				comp_botones_2.setAttribute("name","comp_botones_2");
				comp_botones_2.setAttribute("defaultTexts", this.defaultTexts);
				comp_botones_2.setAttribute("defaultImages", this.defaultImages);
				frame_100.appendChild(comp_botones_2);
			}


			/* if attribute is true, add declared instances AFTER all is loaded */
			if (this.getAttribute("addDeclaredInstances") != "false") {
				addEventListener("load", (event) => {
					wcf_allInstances.addDeclaredInstances(tagId);
				});
			}

			/* Add observers for backgrounds AFTER comp is full rendered, and register observers */
			wcf_allInstances.waitForInstance(tagId).then((instance) => {
				for (let i = 0; i < cssBkgImages.length; i++) {
					wcf_allInstances.attrObserveRegister(tagId, cssBkgImages[i][1]+"_srcbkg", {"type":"srcBkg", "wcfAttr": true}, false);
				}
			});

			/* if it's root and has variat defaults, set them */
			if (this.hasShadow && this.instanceVariantDefaults) {
				wcf_allInstances.setInstanceVariantDefaults(tagId, this.instanceVariantDefaults);
			}

			/* if component has custom JS, it goes here */

		}

		mutationObserverCallback(mutationList, observer) {
			for (const mutation of mutationList) {
				wcf_allInstances.attrObserveCallback(mutation.target, mutation.attributeName, mutation.oldValue, mutation.target.getAttribute(mutation.attributeName));
			}
		}
	}
	customElements.define("comp-site-card", site_card);

/* WCF version: 0.9.0004 */