	import {wcf_allInstances} from "./wcfManage.js";

	class botones extends HTMLElement {
		static attributes = {};
		urlBase = ".";
		
		hasShadow;
		variantsData;
		instanceVariantDefaults = {};
		emptySvg = 'data:image/svg+xml;charset=utf-8, <svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg"><rect width="100%" height="100%" style="fill-opacity:0;" /></svg>';
		defaultTexts = "off";
		defaultImages = "off";

		constructor() {
			super();
			this.urlBase = wcf_allInstances.actualUrlBase("./js/site-card.js");
			this.variantsData = [{"add":{},"remove":{},"modify":{"botones":{"class":"css-botones-3 botones"},"button":{"class":"css-Button-3 button"}},"attrNames":"Property_1-secondary"},{"add":{},"remove":{},"modify":{"botones":{"class":"botones_1-diff1"},"button":{"class":"button-diff1"}},"attrNames":"Property_1-primary"}];
		}

		replaceDefaults(newDefaults) {
			this.instanceVariantDefaults = newDefaults;
		}

		connectedCallback() {
			let compId;
			let shadow;

			if (this.hasAttribute("defaultTexts")) {
				this.defaultTexts = this.getAttribute("defaultTexts");
			}
			if (this.hasAttribute("defaultImages")) {
				this.defaultImages = this.getAttribute("defaultImages");
			}

			if (this.getRootNode().host) {
				this.hasShadow = false;
			} else {
				this.hasShadow = true;
				shadow = this.attachShadow({ mode: "open", delegatesFocus: true});
			}

			/* add the component to the global component list */
			const tagIdOri = this.getAttribute("id");
			let tagIdValue;
			if (tagIdOri) {
				tagIdValue = wcf_allInstances.getUniqueInstanceId(tagIdOri);
			} else {
				tagIdValue = wcf_allInstances.getUniqueInstanceId("compInstance");
			}
			const tagId = tagIdValue;
			wcf_allInstances.addInstance(tagId, this, this.hasShadow);
			wcf_allInstances.addProp(tagId, "oriComp", "botones");
			wcf_allInstances.allCompsIds[tagId] = {};
			this.setAttribute("id",tagId);


			/* Add the attributes mutation observer */
			this.mutationObserver = new MutationObserver(this.mutationObserverCallback);
			this.mutationObserver.observe(this, {attributes: true, attributeOldValue: true});

			const botones = document.createElement("div");
			botones.setAttribute("data-wcfid", "botones");
			botones.setAttribute("original-id", "68:57");
			botones.setAttribute("data-name", "botones");
			botones.setAttribute("data-component-id", "botones");
			botones.setAttribute("data-string-attr", "Property_1-secondary");
			botones.setAttribute("data-is-variant-default", "true");
			botones.setAttribute("class", "css-botones-3 botones");
			botones.setAttribute("data-wcfid", "botones");
			wcf_allInstances.allCompsIds[tagId]["botones"] = botones;
			if (this.hasShadow) {
				shadow.appendChild(botones);
			} else {
				this.appendChild(botones);
			}

			if (this.hasShadow) {
				const cssReset = document.createElement("link");
				cssReset.setAttribute("rel", "stylesheet");
				cssReset.setAttribute("href", this.urlBase+"/css/reset.css");
				shadow.appendChild(cssReset);

			}
			/* if component has private styles, they go here */
			let cssText =' .botones {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; box-sizing:border-box; display:flex; width:100%; height:fit-content; flex-flow:row; gap:10px; justify-content:center; align-items:center; padding:6px 18px; color:rgb(0, 71, 255); background-color:rgb(0, 71, 255); border:1px solid rgb(0, 71, 255); border-radius:8px; } .button {min-height:1.05703422em; font-style:normal; font-variant:normal; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; vertical-align:baseline; background:transparent; color:rgb(255, 255, 255); font-family:Inter; font-weight:500; font-size:14px; text-align:left; letter-spacing:0px; line-height:16.8px; } blockquote::before, blockquote::after, q::before, q::after {content: none;} blockquote::before, blockquote::after, q::before, q::after {content: none;} .botones_1-diff1{color:rgb(255, 255, 255); background-color:rgb(255, 255, 255); } .button-diff1{color:rgb(0, 71, 255); }';
			const cssBkgImages = [...cssText.matchAll(/\.([^ {}]+) *{[^{]*background-image:url\("(.*?)"/g)];
			if (this.defaultImages != "on") {
				for (let i = 0; i < cssBkgImages.length; i++) {
					cssText = cssText.replace("background-image:url(\""+cssBkgImages[i][2]+"\")", "background-image:none");
				}
			}

			if (typeof switchesCssText != "undefined") {
				cssText += switchesCssText;
			}
			let style = document.createElement("style");
			style.type = "text/css";
			style.textContent = cssText;
			if (this.hasShadow) {
				shadow.appendChild(style);
			} else {
				this.appendChild(style);
			}
			/* Fonts need to be added to document head also in order to work properly */
			let sheet = window.document.styleSheets[0];
			if (typeof sheet == "undefined") {
				sheet = new CSSStyleSheet();
				document.adoptedStyleSheets = [sheet];
			}
			let rule;
			rule = '@font-face {font-family: Inter; font-style: normal; font-weight: 400; src: url('+this.urlBase+'/fonts/Inter-Regular.ttf);}';
			if (!wcf_allInstances.isFontLoaded(rule)) {
				sheet.insertRule(rule,sheet.cssRules.length);
			}
			rule = '@font-face {font-family: Inter; font-style: normal; font-weight: 500; src: url('+this.urlBase+'/fonts/Inter-Medium.ttf);}';
			if (!wcf_allInstances.isFontLoaded(rule)) {
				sheet.insertRule(rule,sheet.cssRules.length);
			}
			rule = '@font-face {font-family: Inter; font-style: normal; font-weight: 600; src: url('+this.urlBase+'/fonts/Inter-SemiBold.ttf);}';
			if (!wcf_allInstances.isFontLoaded(rule)) {
				sheet.insertRule(rule,sheet.cssRules.length);
			}



			const button = document.createElement("p");
			button.setAttribute("data-wcfid", "button");
			button.setAttribute("original-id", "68:58");
			button.setAttribute("data-name", "button");
			button.setAttribute("class", "css-Button-3 button");
			button.setAttribute("data-wcfid", "button");
			wcf_allInstances.allCompsIds[tagId]["button"] = button;


			/* get the parameter if exists */
			var buttontext = this.getAttribute("button");
			if (this.defaultTexts == "on") {
				button.textContent = "Button";
			} else {
				button.textContent = " ";
			}
			if (this.hasAttribute("button")) {
				button.textContent = this.getAttribute("button");
			}

			/* Register the attribute for the observer */
			wcf_allInstances.attrObserveRegister(tagId,"button", {"elem": button, "type":"p", "wcfAttr": true}, false)

			botones.appendChild(button);

			/* if attribute is true, add declared instances AFTER all is loaded */
			if (this.getAttribute("addDeclaredInstances") != "false") {
				addEventListener("load", (event) => {
					wcf_allInstances.addDeclaredInstances(tagId);
				});
			}

			/* Add declared variants AFTER comp is full rendered, and register observers */
			wcf_allInstances.waitForInstance(tagId).then((instance) => {
				// add observer for variants
				this.setVariantsData = wcf_allInstances.addAllVariants(tagId, this.variantsData);
				wcf_allInstances.attrObserveRegister(tagId, "variant", {variantsData:this.variantsData, setVariantsData:this.setVariantsData}, wcf_allInstances.variantObserver);
			});

			/* Add observers for backgrounds AFTER comp is full rendered, and register observers */
			wcf_allInstances.waitForInstance(tagId).then((instance) => {
				for (let i = 0; i < cssBkgImages.length; i++) {
					wcf_allInstances.attrObserveRegister(tagId, cssBkgImages[i][1]+"_srcbkg", {"type":"srcBkg", "wcfAttr": true}, false);
				}
			});

			/* if it's root and has variat defaults, set them */
			if (this.hasShadow && this.instanceVariantDefaults) {
				wcf_allInstances.setInstanceVariantDefaults(tagId, this.instanceVariantDefaults);
			}

			/* if component has custom JS, it goes here */

		}

		mutationObserverCallback(mutationList, observer) {
			for (const mutation of mutationList) {
				wcf_allInstances.attrObserveCallback(mutation.target, mutation.attributeName, mutation.oldValue, mutation.target.getAttribute(mutation.attributeName));
			}
		}
	}
	customElements.define("comp-botones", botones);

/* WCF version: 0.9.0004 */