import { Injectable } from "@angular/core";
import { Subject } from "rxjs";

@Injectable({ providedIn: "root" })
export class WcfSubcomps {
	private renderedComps:any = {};
	private storedMessages:any = {};

	private attributesObs = new Subject<any>();
	attributes = this.attributesObs.asObservable();

	changeAttribute(newAttribute: any) {
		// if component has been created or destroyed.
		if (newAttribute.hasOwnProperty("hasBeenRendered")) {
			if (newAttribute.hasBeenRendered === "true") {
				if (newAttribute.hasOwnProperty("id")) {
					this.renderedComps[newAttribute.id] = true;
					this.sendStoredMessages(newAttribute.id);
				}
			} else if (newAttribute.hasBeenRendered === "false") {
				this.renderedComps[newAttribute.id] = false;
			}
		}

		this.storeMessage(newAttribute);				// always store message, to restore status if comp is destroyed and created again
		this.attributesObs.next(newAttribute); 			// always send message for compatibility con old service versions
	}

	storeMessage(newAttribute:any) {
		if (!this.storedMessages[newAttribute.id]) {
			this.storedMessages[newAttribute.id] = {}; 
		}
		let inputKey = this.getInputKey(newAttribute); 		// use inputKey to have only last value for each input
		this.storedMessages[newAttribute.id][inputKey] = newAttribute;
	}

	sendStoredMessages(id:string) {
		if (this.storedMessages[id]) {
			for (let inputKey in this.storedMessages[id]) {
				this.attributesObs.next(this.storedMessages[id][inputKey]);
			}
		}
	}
	
	getInputKey(newAttribute:any) {
		let keys = Object.keys(newAttribute); 
		if (keys[1] !== "id") {
			return keys[1]; 
		} 
		return keys[0];
	}
		

}
