import { Component, model, SimpleChanges, OnInit, ElementRef  } from "@angular/core";
import { WcfSubcomps } from "../wcf-subcomps/wcf-subcomps.service";
import { Subscription } from "rxjs";
/* Import sub components */
import { Botones } from "../botones/botones.component"

@Component({
	selector: "comp-site-card",
	standalone: true,
	imports: [Botones],
	templateUrl: "./site-card.component.html",
	styleUrl: "./site-card.component.css"
})

export class SiteCard {
	id = model<string>("");
	defaultTexts = model<string>("off");
	defaultImages = model<string>("off");
	wcfHighlight:boolean = false;		// for debugging purpose

	/* Input bindings for text */
	s22_november = model<string>(" ");
	design = model<string>(" ");
	top_10_product_design_ideas = model<string>(" ");


	/* empty SVG as default for defaultImages "off" */
	emptySvg = 'data:image/svg+xml;charset=utf-8, <svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg"><rect width="100%" height="100%" style="fill-opacity:0;" /></svg>';

	vector_rectangle_1_src = model<string>(this.emptySvg);
	vector_rectangle_3_src = model<string>(this.emptySvg);

	wcfSubcompsSubscription: Subscription;

	constructor(private wcfSubcompsService: WcfSubcomps, private elem: ElementRef) {
		this.wcfSubcompsSubscription = Subscription.EMPTY;
	}

	ngOnInit() {
		this.wcfSubcompsSubscription = this.wcfSubcompsService.attributes.subscribe(attrData => this.changeAttr(attrData));
		this.wcfSubcompsService.changeAttribute({"id":this.id(), "hasBeenRendered":"true"});

		if (this.defaultTexts() == "on") {
			this.s22_november.update((a) => a === " " ? "22 November" : a);
			this.design.update((a) => a === " " ? "Design" : a);
			this.top_10_product_design_ideas.update((a) => a === " " ? "Top 10 product design ideas" : a);
		}
		if (this.defaultImages() == "on") {
			this.vector_rectangle_1_src.update((a) => a === this.emptySvg ? "assets/img/vectors6442.svg" : a);
			this.vector_rectangle_3_src.update((a) => a === this.emptySvg ? "assets/img/vectors6445.svg" : a);
		}
	}

	ngOnDestroy() {
		this.wcfSubcompsService.changeAttribute({"id":this.id(), "hasBeenRendered":"false"});
		this.wcfSubcompsSubscription.unsubscribe();
	}

	changeAttr(attrData:any) {
		if (attrData.id && attrData.id == this.id()) {
			if (attrData.hasOwnProperty("s22_november")) {
				this.s22_november.set(attrData.s22_november);
			}
			if (attrData.hasOwnProperty("design")) {
				this.design.set(attrData.design);
			}
			if (attrData.hasOwnProperty("top_10_product_design_ideas")) {
				this.top_10_product_design_ideas.set(attrData.top_10_product_design_ideas);
			}
			if (attrData.hasOwnProperty("vector_rectangle_1_src")) {
				this.vector_rectangle_1_src.set(attrData.vector_rectangle_1_src);
			}
			if (attrData.hasOwnProperty("vector_rectangle_3_src")) {
				this.vector_rectangle_3_src.set(attrData.vector_rectangle_3_src);
			}
			if (attrData.hasOwnProperty("wcfHighlight")) {			// for debugging prupose
				this.wcfHighlight = attrData.wcfHighlight;
			}
		}
	}

	/* if component has custom TypeScript for export class, it goes here */
}

