import { Component, ViewChild, AfterViewInit, OnInit, ElementRef} from '@angular/core';
import { WcfSubcomps } from "./wcf-subcomps/wcf-subcomps.service";
import { Subscription } from "rxjs";

import { AppDemo } from "./app-demo-site-card/app-demo.component";

@Component({
  selector: 'app-root',
  standalone: true,
  imports: [AppDemo],
	template: "<app-demo></app-demo>", 
})

export class AppComponent {
	title = 'app-demo';// 
	
	wcfSubcompsSubscription: Subscription;
	
	constructor(private wcfSubcompsService: WcfSubcomps) {
		this.wcfSubcompsSubscription = Subscription.EMPTY;
	}
	
	ngOnInit() {
		this.wcfSubcompsService.changeAttribute({"id":"site-card.botones",   "variant":"1"});
		this.wcfSubcompsService.changeAttribute({"id":"site-card.botones_1", "variant":"1"});
		this.wcfSubcompsService.changeAttribute({"id":"site-card.botones_2", "variant":"1"});
		
		this.wcfSubcompsService.changeAttribute({"id":"site-card.botones",   "button":"UX/UI"});
		this.wcfSubcompsService.changeAttribute({"id":"site-card.botones_1", "button":"Design"});
		this.wcfSubcompsService.changeAttribute({"id":"site-card.botones_2", "button":"CSS"});

	}
}