import { Component } from "@angular/core";
import { WcfSubcomps } from "../wcf-subcomps/wcf-subcomps.service";
import { SiteCard } from "../site-card/site-card.component";

@Component({
	selector: "app-demo",
	standalone: true,
	imports: [SiteCard],
	templateUrl: "app-demo.component.html",
})

export class AppDemo {
	title = "Demo for site-card";
	toggleValues:any = {};
	emptySvg = 'data:image/svg+xml;charset=utf-8, <svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg"><rect width="100%" height="100%" style="fill-opacity:0;" /></svg>';


	totalwrap: any = {"width":"100vw", "display":"flex", "flex-direction":"row", "position":"relative", "box-sizing":"border-box", "overflow":"hidden", "padding-top":"40px"};
	contentwrap: any = {"box-sizing":"border-box", "background-color":"#fff", "width":"fit-content", "height":"fit-content", "flexGrow" : "0", "overflow":"auto", "flex": "0 0 auto", "max-height": "calc(100vh - 40px)", "max-width": "calc(100vw - 400px)", "scrollbar-width": "thin"};
	contentbody: any = {"background-color":"#fff", "width":"min-content",  "min-width":"320px"};
	panelwrap: any = {"height":"calc(100vh - 40px)", "overflow":"auto", "scroll-margin-bottom":"50px", "flex-grow":"1", "padding-inline":"24px", "border-left":"1px solid #ccc", "box-sizing":"border-box", "background-color":"#fff", "min-width":"400px"};
	
	private direction:string = "cols";
	
	contentWidth = 769;
	contentWrapWidth = this.contentWidth + 16;
	contentHeight = 600;
	

	constructor(private wcfSubcompsService: WcfSubcomps) { 
		// agregar
		document.body.style.margin = "0px";
		document.body.style.backgroundColor = "#f0f0f0";
    }


	setDescendant(data:any) {
		this.wcfSubcompsService.changeAttribute(data);
	}
	
	

	rotate(event:any) {
		let overwrite:any;
		if (event.target.value == "rows") {
			this.direction = "rows";
			console.log("entre por rows", this.contentHeight , window.innerHeight,  window.innerHeight-300);
			
			overwrite = {"max-width":"100vw", "width":"100%"};
			this.contentwrap = {...this.contentwrap, ...overwrite};
						
			overwrite = {"width":"100%"};
			this.panelwrap = {...this.panelwrap, ...overwrite};
			
			overwrite = {"width":"auto"};
			this.totalwrap = {...this.totalwrap, ...overwrite};
			
			if (this.contentHeight < window.innerHeight - 300) {
				overwrite = {"flex-direction":"column"};
				this.totalwrap = {...this.totalwrap, ...overwrite};
				
				overwrite = {"height":(window.innerHeight - this.contentHeight - 40)+"px", "min-height":"300px", "border-top":"1px solid #ccc", "overflow-y":"auto"};
				this.panelwrap = {...this.panelwrap, ...overwrite};
			} else {
				overwrite = {"display":"block"};
				this.totalwrap = {...this.totalwrap, ...overwrite};
				
				overwrite = {"height":"auto", "border-top":"1px solid #ccc"};
				this.panelwrap = {...this.panelwrap, ...overwrite};
			}
			
		} else {
			this.direction = "cols";
			let width:number; 
			let height:number;
			
			console.log("entre por no son  rows");
			let overwrite:any = {"display":"flex", "flex-direction":"row"};
			this.totalwrap = {...this.totalwrap, ...overwrite};
			
			overwrite = {"max-width":"calc(100vw - 400px)", "width":this.contentWrapWidth+"px", "height":this.contentHeight+"px"};
			this.contentwrap = {...this.contentwrap, ...overwrite};
             
			if (this.contentWidth > window.innerWidth - 400) {
				height = window.innerHeight - 60;
				overwrite = {"width":"400px", "height":height.toString()+"px"};
				this.panelwrap = {...this.panelwrap, ...overwrite};
				
				width = this.contentWidth + 400
				overwrite = {"width":width.toString()+"px"};
				this.totalwrap = {...this.totalwrap, ...overwrite};
			} else {
				width = window.innerWidth - this.contentWidth; 
				height = window.innerHeight - 40;
				overwrite = {"min-width":"400px", "width": width.toString()+"px", "height":height.toString()+"px"};
				this.panelwrap = {...this.panelwrap, ...overwrite};
			}
		}
		if (this.contentHeight > window.innerHeight) {
			let height = window.innerHeight - 40;
			overwrite = {"height":height.toString()+"px"};
			this.contentwrap = {...this.contentwrap, ...overwrite};
       	}
	}

	changeWidth(event:any) {
		let overwrite:any;		
		if (event.target.value <= 2000) {
			this.contentWidth = event.target.value;
			this.contentWrapWidth = Number(this.contentWidth) + 16;
			if (this.direction == "cols") {
				if (this.contentWidth > window.innerWidth) {
					overwrite = {"width":"100vw"}
					this.contentwrap = {...this.contentwrap, ...overwrite};
				} else {
					overwrite = {"width":this.contentWidth.toString+"px"};
					this.contentwrap = {...this.contentwrap, ...overwrite};
					
					overwrite = {"overflow-x":"hidden"};
					this.totalwrap = {...this.totalwrap, ...overwrite};
				}
			} else {
				if (this.contentWidth > window.innerWidth) {
					let height = window.innerHeight - 60;
					overwrite = {"width":"400px", "height":height.toString()+"px"};
					this.panelwrap = {...this.panelwrap, ...overwrite};
					
				} else {
					let width = window.innerWidth - this.contentWidth;
					let height = window.innerHeight - 40;
					overwrite = {"width":width.toString()+"px", "height":height.toString()+"px"};
					this.panelwrap = {...this.panelwrap, ...overwrite};
					
					
				}
     	    }
		} 
	}

	changeHeight(event:any) {
		let overwrite:any;
		if (event.target.value <= 2000) {
			this.contentHeight = event.target.value;
			if (this.direction == "rows") {
				console.log("entre por cols");
			
				if (this.contentHeight > window.innerHeight - 40) {
					overwrite = {"display":"block"};
					this.totalwrap = {...this.totalwrap, ...overwrite};
					
					overwrite = {"height":"auto"};
					this.contentwrap = {...this.contentwrap, ...overwrite};
					
					overwrite = {"height":"auto", "border-top":"1px solid #ccc"};
					this.panelwrap = {...this.panelwrap, ...overwrite};
				} else {
					let height:number;
					overwrite = {"flex-direction":"column"};
					this.totalwrap = {...this.totalwrap, ...overwrite};
					
					overwrite = {"overflow":"auto"};
					this.contentwrap = {...this.contentwrap, ...overwrite};
					
					height = window.innerHeight - this.contentHeight - 40;
					overwrite = {"height":height.toString()+"px", "min-height":"300px", "overflow-y":"auto", "border-top":"1px solid #ccc"};
					this.panelwrap = {...this.panelwrap, ...overwrite};
				}
		
			} else {
				let height:number;
				if (this.contentHeight > window.innerHeight - 40) {
					height =  window.innerHeight - 40;
					overwrite = {"height":height.toString()+"px"};
					this.contentwrap = {...this.contentwrap, ...overwrite};
					
					overwrite = {"height":this.contentHeight.toString()+"px"};
					this.contentbody = {...this.contentbody, ...overwrite};
				} else {
					overwrite = {"height":this.contentHeight.toString()+"px"};
					this.contentwrap = {...this.contentwrap, ...overwrite};
					
					overwrite = {"height":"auto"};
					this.contentbody = {...this.contentbody, ...overwrite};
				}
			}
		}
	}

	compHiglight(event:any, id:string) {
		if (event.target.checked) {
			this.wcfSubcompsService.changeAttribute({id:id, wcfHighlight: true});
		} else {
			this.wcfSubcompsService.changeAttribute({id:id, wcfHighlight: false});
		}
	}
	toggleTexts(mode:string) {
		if (mode == "toEmpty") {
			this.toggleValues["site-card"] = {};
			this.toggleValues["site-card"]["s22_november"] = "22 November";
			this.wcfSubcompsService.changeAttribute({"id":"site-card", "s22_november":" "});
			this.toggleValues["site-card"]["design"] = "Design";
			this.wcfSubcompsService.changeAttribute({"id":"site-card", "design":" "});
			this.toggleValues["site-card"]["top_10_product_design_ideas"] = "Top 10 product design ideas";
			this.wcfSubcompsService.changeAttribute({"id":"site-card", "top_10_product_design_ideas":" "});


			this.toggleValues["site-card.botones"] = {};
			this.toggleValues["site-card.botones"]["button"] = "Button";
			this.wcfSubcompsService.changeAttribute({"id":"site-card.botones", "button":" "});


			this.toggleValues["site-card.botones_1"] = {};
			this.toggleValues["site-card.botones_1"]["button"] = "Button";
			this.wcfSubcompsService.changeAttribute({"id":"site-card.botones_1", "button":" "});


			this.toggleValues["site-card.botones_2"] = {};
			this.toggleValues["site-card.botones_2"]["button"] = "Button";
			this.wcfSubcompsService.changeAttribute({"id":"site-card.botones_2", "button":" "});


		}
		if (mode == "restore") {
			if (this.toggleValues.hasOwnProperty("site-card")) {
				this.wcfSubcompsService.changeAttribute({"id":"site-card", "s22_november":this.toggleValues["site-card"]["s22_november"]});
				this.wcfSubcompsService.changeAttribute({"id":"site-card", "design":this.toggleValues["site-card"]["design"]});
				this.wcfSubcompsService.changeAttribute({"id":"site-card", "top_10_product_design_ideas":this.toggleValues["site-card"]["top_10_product_design_ideas"]});
			}

			if (this.toggleValues.hasOwnProperty("site-card.botones")) {
				this.wcfSubcompsService.changeAttribute({"id":"site-card.botones", "button":this.toggleValues["site-card.botones"]["button"]});
			}

			if (this.toggleValues.hasOwnProperty("site-card.botones_1")) {
				this.wcfSubcompsService.changeAttribute({"id":"site-card.botones_1", "button":this.toggleValues["site-card.botones_1"]["button"]});
			}

			if (this.toggleValues.hasOwnProperty("site-card.botones_2")) {
				this.wcfSubcompsService.changeAttribute({"id":"site-card.botones_2", "button":this.toggleValues["site-card.botones_2"]["button"]});
			}

		}
	}

	textInputs(event:any) {
		if (event.target.checked) {
			this.toggleTexts("toEmpty");
		} else {
			this.toggleTexts("restore");
		}
	}

	toggleImages(mode:string) {
		if (mode == "toEmpty") {
			this.toggleValues["site-card_src"] = {};
			this.toggleValues["site-card_src"]["vector_rectangle_1_src"] = "assets/img/vectors6442.svg";
			this.wcfSubcompsService.changeAttribute({"id":"site-card", "vector_rectangle_1_src":this.emptySvg});
			this.toggleValues["site-card_src"]["vector_rectangle_3_src"] = "assets/img/vectors6445.svg";
			this.wcfSubcompsService.changeAttribute({"id":"site-card", "vector_rectangle_3_src":this.emptySvg});


			this.toggleValues["site-card.botones_src"] = {};


			this.toggleValues["site-card.botones_1_src"] = {};


			this.toggleValues["site-card.botones_2_src"] = {};


		}
		if (mode == "restore") {
			if (this.toggleValues.hasOwnProperty("site-card_src")) {
				this.wcfSubcompsService.changeAttribute({"id":"site-card", "vector_rectangle_1_src":this.toggleValues["site-card_src"]["vector_rectangle_1_src"]});
				this.wcfSubcompsService.changeAttribute({"id":"site-card", "vector_rectangle_3_src":this.toggleValues["site-card_src"]["vector_rectangle_3_src"]});
			}

			if (this.toggleValues.hasOwnProperty("site-card.botones_src")) {
			}

			if (this.toggleValues.hasOwnProperty("site-card.botones_1_src")) {
			}

			if (this.toggleValues.hasOwnProperty("site-card.botones_2_src")) {
			}

		}
	}

	imageInputs(event:any) {
		if (event.target.checked) {
			this.toggleImages("toEmpty");
		} else {
			this.toggleImages("restore");
		}
	}


}