	import {wcf_allInstances} from "./wcfManage.js";

	class buttons extends HTMLElement {
		static attributes = {};
		urlBase = ".";
		
		hasShadow;
		variantsData;
		instanceVariantDefaults = {};
		emptySvg = 'data:image/svg+xml;charset=utf-8, <svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg"><rect width="100%" height="100%" style="fill-opacity:0;" /></svg>';
		defaultTexts = "off";
		defaultImages = "off";

		/* Component form data */
		static formAssociated = true;
		formFields = {};
		formData;
		attachedInternals;
		labelChanges= {};

		constructor() {
			super();
			this.urlBase = wcf_allInstances.actualUrlBase("./js/buttons.js");
			this.variantsData = [{"add":{},"remove":{},"modify":{"buttons":{"class":"css-Buttons buttons"},"button_full_solid":{"class":"css-button_full_solid button_full_solid"},"button":{"class":"css-BUTTON button"}},"attrNames":"State-Default--Size-Full--Style-Solid"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_1-diff1"},"button_full_solid":{"class":"button_pressed_full_solid-diff1"},"button":{"class":"button-diff1"}},"attrNames":"State-Pressed--Size-Full--Style-Solid"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_2-diff2"},"button_full_solid":{"class":"button_half_solid-diff2"},"button":{"class":"button-diff2"}},"attrNames":"State-Default--Size-Half--Style-Solid"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_3-diff3"},"button_full_solid":{"class":"button_pressed_half_soldi-diff3"},"button":{"class":"button-diff3"}},"attrNames":"State-Pressed--Size-Half--Style-Solid"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_4-diff4"},"button_full_solid":{"class":"button_full_stroke-diff4"},"button":{"class":"button-diff4"}},"attrNames":"State-Default--Size-Full--Style-Stroke"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_5-diff5"},"button_full_solid":{"class":"button_pressed_full_stroki-diff5"},"button":{"class":"button-diff5"}},"attrNames":"State-Pressed--Size-Full--Style-Stroke"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_6-diff6"},"button_full_solid":{"class":"button_half_stroke-diff6"},"button":{"class":"button-diff6"}},"attrNames":"State-Default--Size-Half--Style-Stroke"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_7-diff7"},"button_full_solid":{"class":"button_pressed_half_stroke-diff7"},"button":{"class":"button-diff7"}},"attrNames":"State-Pressed--Size-Half--Style-Stroke"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_8-diff8"},"button_full_solid":{"class":"button_full_light-diff8"},"button":{"class":"button-diff8"}},"attrNames":"State-Default--Size-Full--Style-Light"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_9-diff9"},"button_full_solid":{"class":"button_full_dark-diff9"},"button":{"class":"button-diff9"}},"attrNames":"State-Default--Size-Full--Style-Dark"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_10-diff10"},"button_full_solid":{"class":"button_half_ligth-diff10"},"button":{"class":"button-diff10"}},"attrNames":"State-Default--Size-Half--Style-Light"},{"add":{},"remove":{},"modify":{"buttons":{"class":"buttons_11-diff11"},"button_full_solid":{"class":"button_half_dark-diff11"},"button":{"class":"button-diff11"}},"attrNames":"State-Default--Size-Half--Style-Dark"}];
		}

		replaceDefaults(newDefaults) {
			this.instanceVariantDefaults = newDefaults;
		}

		connectedCallback() {
			let compId;
			let shadow;

			if (this.hasAttribute("defaultTexts")) {
				this.defaultTexts = this.getAttribute("defaultTexts");
			}
			if (this.hasAttribute("defaultImages")) {
				this.defaultImages = this.getAttribute("defaultImages");
			}

			if (this.getRootNode().host) {
				this.hasShadow = false;
				/* get the host attached form */
				this.attachedInternals = this.getRootNode().host.attachedInternals;
			} else {
				this.hasShadow = true;
				shadow = this.attachShadow({ mode: "open", delegatesFocus: true});
				/* Attach the web component to the containing form */
				this.attachedInternals = this.attachInternals();
			}

			let inputName;
			let labelForId, labelForIdOri;
			this.formData = new FormData();				// Form data is fullfilled onLoad from attachedInternals  

			/* add the component to the global component list */
			const tagIdOri = this.getAttribute("id");
			let tagIdValue;
			if (tagIdOri) {
				tagIdValue = wcf_allInstances.getUniqueInstanceId(tagIdOri);
			} else {
				tagIdValue = wcf_allInstances.getUniqueInstanceId("compInstance");
			}
			const tagId = tagIdValue;
			wcf_allInstances.addInstance(tagId, this, this.hasShadow);
			wcf_allInstances.addProp(tagId, "oriComp", "buttons");
			wcf_allInstances.allCompsIds[tagId] = {};
			this.setAttribute("id",tagId);


			/* Add the attributes mutation observer */
			this.mutationObserver = new MutationObserver(this.mutationObserverCallback);
			this.mutationObserver.observe(this, {attributes: true, attributeOldValue: true});

			const buttons = document.createElement("div");
			buttons.setAttribute("data-wcfid", "buttons");
			buttons.setAttribute("original-id", "60:33");
			buttons.setAttribute("data-name", "buttons");
			buttons.setAttribute("data-component-id", "buttons");
			buttons.setAttribute("data-string-attr", "State-Default--Size-Full--Style-Solid");
			buttons.setAttribute("data-is-variant-default", "true");
			buttons.setAttribute("class", "css-Buttons buttons");
			buttons.setAttribute("data-wcfid", "buttons");
			wcf_allInstances.allCompsIds[tagId]["buttons"] = buttons;
			if (this.hasShadow) {
				shadow.appendChild(buttons);
			} else {
				this.appendChild(buttons);
			}

			if (this.hasShadow) {
				const cssReset = document.createElement("link");
				cssReset.setAttribute("rel", "stylesheet");
				cssReset.setAttribute("href", this.urlBase+"/css/reset.css");
				shadow.appendChild(cssReset);

			}
			/* if component has private styles, they go here */
			let cssText =' .buttons {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; font-size:100%; vertical-align:baseline; background:transparent; box-sizing:border-box; } .button_full_solid {font-style:normal; font-variant:normal; font-weight:400; font-family:serif; font-stretch:100%; background:none; border:medium; padding:0px; font:inherit; outline:rgb(47, 219, 188) 0px; box-sizing:border-box; display:flex; width:335px; height:40px; flex-flow:row; gap:10px; justify-content:center; align-items:center; color:rgb(47, 219, 188); background-color:rgb(47, 219, 188); border-radius:100px; } .button {min-height:1.05703422em; font-style:normal; font-variant:normal; font-stretch:100%; margin:0px; padding:0px; border:0px; outline:0px; vertical-align:baseline; background:transparent; color:rgb(255, 255, 255); font-family:Bebas Neue; font-weight:400; font-size:18px; text-align:center; letter-spacing:0px; line-height:21.6px; } blockquote::before, blockquote::after, q::before, q::after {content: none;} blockquote::before, blockquote::after, q::before, q::after {content: none;} .button_pressed_full_solid-diff1{outline:rgb(30, 174, 148) 0px; color:rgb(30, 174, 148); background-color:rgb(30, 174, 148); } .button_half_solid-diff2{width:157px; flex-flow:column; } .button_pressed_half_soldi-diff3{outline:rgb(30, 174, 148) 0px; width:157px; color:rgb(30, 174, 148); background-color:rgb(30, 174, 148); } .button_full_stroke-diff4{color:rgb(0, 0, 0); outline:rgb(0, 0, 0) 0px; border:2px solid rgb(47, 219, 188); background-color:initial; } .button-diff4{color:rgb(47, 219, 188); } .button_pressed_full_stroki-diff5{color:rgb(0, 0, 0); outline:rgb(0, 0, 0) 0px; border:2px solid rgb(30, 174, 148); background-color:initial; } .button-diff5{color:rgb(30, 174, 148); } .button_half_stroke-diff6{color:rgb(0, 0, 0); outline:rgb(0, 0, 0) 0px; width:157px; border:2px solid rgb(47, 219, 188); background-color:initial; } .button-diff6{color:rgb(47, 219, 188); } .button_pressed_half_stroke-diff7{color:rgb(0, 0, 0); outline:rgb(0, 0, 0) 0px; width:157px; border:2px solid rgb(30, 174, 148); background-color:initial; } .button-diff7{color:rgb(30, 174, 148); } .button_full_light-diff8{outline:rgb(255, 255, 255) 0px; color:rgb(255, 255, 255); background-color:rgb(255, 255, 255); } .button-diff8{color:rgb(47, 219, 188); } .button_full_dark-diff9{outline:rgb(45, 45, 45) 0px; color:rgb(45, 45, 45); background-color:rgb(45, 45, 45); } .button-diff9{color:rgb(47, 219, 188); } .button_half_ligth-diff10{outline:rgb(255, 255, 255) 0px; width:157px; color:rgb(255, 255, 255); background-color:rgb(255, 255, 255); } .button-diff10{color:rgb(47, 219, 188); } .button_half_dark-diff11{outline:rgb(45, 45, 45) 0px; width:157px; color:rgb(45, 45, 45); background-color:rgb(45, 45, 45); } .button-diff11{color:rgb(47, 219, 188); }';
			const cssBkgImages = [...cssText.matchAll(/\.([^ {}]+) *{[^{]*background-image:url\("(.*?)"/g)];
			if (this.defaultImages != "on") {
				for (let i = 0; i < cssBkgImages.length; i++) {
					cssText = cssText.replace("background-image:url(\""+cssBkgImages[i][2]+"\")", "background-image:none");
				}
			}

			if (typeof switchesCssText != "undefined") {
				cssText += switchesCssText;
			}
			let style = document.createElement("style");
			style.type = "text/css";
			style.textContent = cssText;
			if (this.hasShadow) {
				shadow.appendChild(style);
			} else {
				this.appendChild(style);
			}
			/* Fonts need to be added to document head also in order to work properly */
			let sheet = window.document.styleSheets[0];
			if (typeof sheet == "undefined") {
				sheet = new CSSStyleSheet();
				document.adoptedStyleSheets = [sheet];
			}
			let rule;
			rule = '@font-face {font-family: Bebas Neue; font-style: normal; font-weight: 400; src: url('+this.urlBase+'/fonts/BebasNeue-Regular.ttf);}';
			if (!wcf_allInstances.isFontLoaded(rule)) {
				sheet.insertRule(rule,sheet.cssRules.length);
			}



			const button_full_solid = document.createElement("button");
			button_full_solid.setAttribute("data-wcfid", "button_full_solid");
			button_full_solid.setAttribute("original-id", "button_full_solid");
			button_full_solid.setAttribute("id", "button_full_solid");
			button_full_solid.setAttribute("data-name", "button-full-solid");
			button_full_solid.setAttribute("class", "css-button_full_solid button_full_solid");
			button_full_solid.setAttribute("original-id", "75:35");
			button_full_solid.setAttribute("data-wcfid", "button_full_solid");
			wcf_allInstances.allCompsIds[tagId]["button_full_solid"] = button_full_solid;
			buttons.appendChild(button_full_solid);
			if (this.hasAttribute("name")) {
				inputName = this.getAttribute("name");
			} else if (button_full_solid.hasAttribute("name")) {
				inputName = button_full_solid.getAttribute("name");
			} else {
				inputName = "button_full_solid";
			};
			button_full_solid.setAttribute("name",inputName);
			/* set the field value from component attributes */
			wcf_allInstances.setFieldValue(tagId, button_full_solid);
			/* store the aria description for input asociation, if exists */
			if (button_full_solid.getAttribute("aria-describedby")) {
				this.labelChanges[button_full_solid.getAttribute("aria-describedby")] = button_full_solid.getAttribute("aria-describedby");
			}


			const button = document.createElement("p");
			button.setAttribute("data-wcfid", "button");
			button.setAttribute("original-id", "60:35");
			button.setAttribute("data-name", "button");
			button.setAttribute("class", "css-BUTTON button");
			button.setAttribute("data-wcfid", "button");
			wcf_allInstances.allCompsIds[tagId]["button"] = button;


			/* get the parameter if exists */
			var buttontext = this.getAttribute("button");
			if (this.defaultTexts == "on") {
				button.textContent = "BUTTON";
			} else {
				button.textContent = " ";
			}
			if (this.hasAttribute("button")) {
				button.textContent = this.getAttribute("button");
			}

			/* Register the attribute for the observer */
			wcf_allInstances.attrObserveRegister(tagId,"button", {"elem": button, "type":"p", "wcfAttr": true}, false)

			button_full_solid.appendChild(button);

			/* if attribute is true, add declared instances AFTER all is loaded */
			if (this.getAttribute("addDeclaredInstances") != "false") {
				addEventListener("load", (event) => {
					wcf_allInstances.addDeclaredInstances(tagId);
				});
			}

			/* Add declared variants AFTER comp is full rendered, and register observers */
			wcf_allInstances.waitForInstance(tagId).then((instance) => {
				// add observer for variants
				this.setVariantsData = wcf_allInstances.addAllVariants(tagId, this.variantsData);
				wcf_allInstances.attrObserveRegister(tagId, "variant", {variantsData:this.variantsData, setVariantsData:this.setVariantsData}, wcf_allInstances.variantObserver);
			});

			/* Add observers for backgrounds AFTER comp is full rendered, and register observers */
			wcf_allInstances.waitForInstance(tagId).then((instance) => {
				for (let i = 0; i < cssBkgImages.length; i++) {
					wcf_allInstances.attrObserveRegister(tagId, cssBkgImages[i][1]+"_srcbkg", {"type":"srcBkg", "wcfAttr": true}, false);
				}
			});

			/* Set the rigth field ids, values and labels on load */
			wcf_allInstances.setFieldsOnLoad(tagId);

			/* if it's root and has variat defaults, set them */
			if (this.hasShadow && this.instanceVariantDefaults) {
				wcf_allInstances.setInstanceVariantDefaults(tagId, this.instanceVariantDefaults);
			}

			/* if component has custom JS, it goes here */

		}

		mutationObserverCallback(mutationList, observer) {
			for (const mutation of mutationList) {
				wcf_allInstances.attrObserveCallback(mutation.target, mutation.attributeName, mutation.oldValue, mutation.target.getAttribute(mutation.attributeName));
			}
		}
	}
	customElements.define("comp-buttons", buttons);

/* WCF version: 0.9.0004 */