import { useState } from "react";
import styles from "./buttons.module.css";



function variantDefault(props) {
	if (props.hasOwnProperty("variant")) {
		return props.variant;
	} 
	return 0; 
}
function buttonDefault(props) {
	if (props.hasOwnProperty("button")) {
		return props.button;
	} else if (props.hasOwnProperty("defaultTexts") && props.defaultTexts === "on") {
		return "BUTTON"; 
	}
	return " ";
}

export default function Buttons(props) {
	let id = "";
	let defaultTexts = "off";
	let defaultImages = "off";
	if (props.id) {
		id = props.id;
	}
	if (props.defaultTexts) {
		defaultTexts = props.defaultTexts;
	}
	if (props.defaultImages) {
		defaultImages = props.defaultImages;
	}

	const [variant, setvariant] = useState(() => variantDefault(props));
	const [wcfHighlight, setwcfHighlight] = useState("off");					// for app-demo highlight

	const [button, setbutton] = useState(() => buttonDefault(props));

	document.addEventListener("wcfSubcompsService", (e) => {
		if (e.detail.id && e.detail.id === id) {
			if (e.detail.hasOwnProperty("variant")) {
				setvariant(e.detail.variant);
			}
			if (e.detail.hasOwnProperty("wcfHighlight")) {
				setwcfHighlight(e.detail.wcfHighlight);
			}
			if (e.detail.hasOwnProperty("button")) {
				setbutton(e.detail.button);
			}
		}
	});

	let wcfHighlightClass;
	if (wcfHighlight == "on") {
		wcfHighlightClass = styles["wcfHighlightClass"];
	} else {
		wcfHighlightClass = "";
	}	

	let buttons1Diff1 = "";
	let buttons2Diff2 = "";
	let buttons3Diff3 = "";
	let buttons4Diff4 = "";
	let buttons5Diff5 = "";
	let buttons6Diff6 = "";
	let buttons7Diff7 = "";
	let buttons8Diff8 = "";
	let buttons9Diff9 = "";
	let buttons10Diff10 = "";
	let buttons11Diff11 = "";
	let buttonPressedFullSolidDiff1 = "";
	let buttonHalfSolidDiff2 = "";
	let buttonPressedHalfSoldiDiff3 = "";
	let buttonFullStrokeDiff4 = "";
	let buttonPressedFullStrokiDiff5 = "";
	let buttonHalfStrokeDiff6 = "";
	let buttonPressedHalfStrokeDiff7 = "";
	let buttonFullLightDiff8 = "";
	let buttonFullDarkDiff9 = "";
	let buttonHalfLigthDiff10 = "";
	let buttonHalfDarkDiff11 = "";
	let buttonDiff1 = "";
	let buttonDiff2 = "";
	let buttonDiff3 = "";
	let buttonDiff4 = "";
	let buttonDiff5 = "";
	let buttonDiff6 = "";
	let buttonDiff7 = "";
	let buttonDiff8 = "";
	let buttonDiff9 = "";
	let buttonDiff10 = "";
	let buttonDiff11 = "";

	if (variant == 1) {
		buttons1Diff1 = styles["buttons_1-diff1"];
		buttonPressedFullSolidDiff1 = styles["button_pressed_full_solid-diff1"];
		buttonDiff1 = styles["button-diff1"];
	}

	if (variant == 2) {
		buttons2Diff2 = styles["buttons_2-diff2"];
		buttonHalfSolidDiff2 = styles["button_half_solid-diff2"];
		buttonDiff2 = styles["button-diff2"];
	}

	if (variant == 3) {
		buttons3Diff3 = styles["buttons_3-diff3"];
		buttonPressedHalfSoldiDiff3 = styles["button_pressed_half_soldi-diff3"];
		buttonDiff3 = styles["button-diff3"];
	}

	if (variant == 4) {
		buttons4Diff4 = styles["buttons_4-diff4"];
		buttonFullStrokeDiff4 = styles["button_full_stroke-diff4"];
		buttonDiff4 = styles["button-diff4"];
	}

	if (variant == 5) {
		buttons5Diff5 = styles["buttons_5-diff5"];
		buttonPressedFullStrokiDiff5 = styles["button_pressed_full_stroki-diff5"];
		buttonDiff5 = styles["button-diff5"];
	}

	if (variant == 6) {
		buttons6Diff6 = styles["buttons_6-diff6"];
		buttonHalfStrokeDiff6 = styles["button_half_stroke-diff6"];
		buttonDiff6 = styles["button-diff6"];
	}

	if (variant == 7) {
		buttons7Diff7 = styles["buttons_7-diff7"];
		buttonPressedHalfStrokeDiff7 = styles["button_pressed_half_stroke-diff7"];
		buttonDiff7 = styles["button-diff7"];
	}

	if (variant == 8) {
		buttons8Diff8 = styles["buttons_8-diff8"];
		buttonFullLightDiff8 = styles["button_full_light-diff8"];
		buttonDiff8 = styles["button-diff8"];
	}

	if (variant == 9) {
		buttons9Diff9 = styles["buttons_9-diff9"];
		buttonFullDarkDiff9 = styles["button_full_dark-diff9"];
		buttonDiff9 = styles["button-diff9"];
	}

	if (variant == 10) {
		buttons10Diff10 = styles["buttons_10-diff10"];
		buttonHalfLigthDiff10 = styles["button_half_ligth-diff10"];
		buttonDiff10 = styles["button-diff10"];
	}

	if (variant == 11) {
		buttons11Diff11 = styles["buttons_11-diff11"];
		buttonHalfDarkDiff11 = styles["button_half_dark-diff11"];
		buttonDiff11 = styles["button-diff11"];
	}

	return (
		<div
		   id="60:33"
		   dataName="buttons"
		   dataComponentId="buttons"
		   dataStringAttr="State-Default--Size-Full--Style-Solid"
		   dataIsVariantDefault="true"
		   className={styles["css-Buttons"]+" "+styles["buttons"]+" "+wcfHighlightClass+" "+`${buttons1Diff1}`+"  "+`${buttons2Diff2}`+"  "+`${buttons3Diff3}`+"  "+`${buttons4Diff4}`+"  "+`${buttons5Diff5}`+"  "+`${buttons6Diff6}`+"  "+`${buttons7Diff7}`+"  "+`${buttons8Diff8}`+"  "+`${buttons9Diff9}`+"  "+`${buttons10Diff10}`+"  "+`${buttons11Diff11}`}
		   dataWcfid="buttons">
			<button
			   id="button_full_solid"
			   dataName="button-full-solid"
			   className={styles["css-button_full_solid"]+" "+styles["button_full_solid"]+" "+`${buttonPressedFullSolidDiff1}`+"  "+`${buttonHalfSolidDiff2}`+"  "+`${buttonPressedHalfSoldiDiff3}`+"  "+`${buttonFullStrokeDiff4}`+"  "+`${buttonPressedFullStrokiDiff5}`+"  "+`${buttonHalfStrokeDiff6}`+"  "+`${buttonPressedHalfStrokeDiff7}`+"  "+`${buttonFullLightDiff8}`+"  "+`${buttonFullDarkDiff9}`+"  "+`${buttonHalfLigthDiff10}`+"  "+`${buttonHalfDarkDiff11}`}
			   originalId="75:35"
			   dataWcfid="button_full_solid">
				<p
				   id="60:35"
				   dataName="button"
				   className={styles["css-BUTTON"]+" "+styles["button"]+" "+`${buttonDiff1}`+"  "+`${buttonDiff2}`+"  "+`${buttonDiff3}`+"  "+`${buttonDiff4}`+"  "+`${buttonDiff5}`+"  "+`${buttonDiff6}`+"  "+`${buttonDiff7}`+"  "+`${buttonDiff8}`+"  "+`${buttonDiff9}`+"  "+`${buttonDiff10}`+"  "+`${buttonDiff11}`}
				   dataWcfid="button">
					{button}
				</p>
			</button>
		</div>
	)

}
