import { useState } from "react";
import "./app-demo.css";

import Buttons from "../buttons/buttons"

export default function  AppDemo() {

	const [contentWidth, setcontentWidth] = useState(600);
	const [contentWrapWidth, setcontentWrapWidth] = useState(616);
	const [contentHeight, setcontentHeight] = useState(400);

	const [totalWrapClass, settotalWrapClass] = useState("total-wrap");
	const [contentWrapClass, setcontentWrapClass] = useState("content-wrap");
	const [contentBodyClass, setcontentBodyClass] = useState("content-body");
	const [panelWrapClass, setpanelWrapClass] = useState("panel-wrap");

	document.addEventListener("appDemoService", (e) => {
		if (e.detail.id && e.detail.id === "appDemo") {
			if (e.detail.hasOwnProperty("rows")) {
				settotalWrapClass("total-wrap total-wrap-rows");
				setcontentWrapClass("content-wrap content-wrap-rows");
				setcontentBodyClass("body-wrap body-wrap-rows");
				setpanelWrapClass("panel-wrap panel-wrap-rows");
			} else if (e.detail.hasOwnProperty("cols")) {
				settotalWrapClass("total-wrap total-wrap-cols");
				setcontentWrapClass("content-wrap content-wrap-cols");
				setcontentBodyClass("body-wrap body-wrap-cols");
				setpanelWrapClass("panel-wrap panel-wrap-cols");
			}
			if (e.detail.hasOwnProperty("contentWidth")) {
				setcontentWidth(Number(e.detail.contentWidth));
				setcontentWrapWidth(Number(e.detail.contentWidth)+16);
			}
			if (e.detail.hasOwnProperty("contentHeight")) {
				setcontentHeight(Number(e.detail.contentHeight));
			}
			
		}
	});

	return(<>			<div id="topbar" className="top-bar" >
				<div className="row-col">
					<p className="no-margin"><b>Disposition:</b></p> 
					<div className="control-input">
						<input type="radio" name="disposicion" value="rows" className="no-margin-top" onClick={(e) => rotate(e)} />
						<label>Rows</label>
					</div>
					<div className="control-input">
						<input type="radio" name="disposicion" value="cols" className="no-margin-top" defaultChecked onClick={(e) => rotate(e)} />
						<label>Columns</label>
					</div>
				</div>
				<div className="range">
					<p className="no-margin"><b>Width (px):</b></p> 
					<div className="control-input">
						<input type="range" id="ancho" name="ancho" min="320" max="2000"  className="width-100" defaultValue="400px" onClick={(e) => changeWidth(e)} />
						<span id="ancho-valor">{contentWidth}</span>
					</div>
				</div>

				<div className="range">
					<p className="no-margin"><b>Height (px):</b></p> 
					<div className="control-input">
						<input type="range" id="altura" name="altura" min="120" max="2000" className="width-100" defaultValue="300px" onClick={(e) => changeHeight(e)} />
						<span id="altura-valor">{contentHeight}</span>
					</div>
				</div>
				<div className="range">
					<div className="control-input">
						<input type="checkbox" id="toggleTexts" onClick={(e) => toggleTexts(e)} />
						<label for="toggleImages">Remove Texts</label>
					</div>
				</div>
				<div className="range">
					<div className="control-input">
						<input type="checkbox" id="toggleImages" onClick={(e) => toggleImages(e)} />
						<label for="toggleImages">Remove Images</label>
					</div>
				</div>
			</div>
<div id="totalwrap" className={totalWrapClass}>
	<div id="contentwrap" className={contentWrapClass} style={{width: contentWrapWidth+"px", height: contentHeight+"px"}}>
		<div id="contentbody" className={contentBodyClass} style={{width: contentWidth+"px", height: contentHeight+"px"}}>
			<Buttons id="buttons" defaultTexts="on" defaultImages="on" variant="0" />
			<div className="expand-bottom"></div>
		</div>
	</div>

	<div id="panelwrap" className={panelWrapClass}>

		<h1 className="comp-title">buttons</h1>

		<h2 className="comp-subtitle">Variants</h2>

		<div className="control-block">
			<input type="radio" name="variants-buttons" id="buttons0" onChange={(e) => sendMessage("buttons", "variant","0")}/>
			<label for="buttons0" className="radio-label">Variant 0</label><br />
			<input type="radio" name="variants-buttons" id="buttons1" onChange={(e) => sendMessage("buttons", "variant","1")}/>
			<label for="buttons1" className="radio-label">Variant 1</label><br />
			<input type="radio" name="variants-buttons" id="buttons2" onChange={(e) => sendMessage("buttons", "variant","2")}/>
			<label for="buttons2" className="radio-label">Variant 2</label><br />
			<input type="radio" name="variants-buttons" id="buttons3" onChange={(e) => sendMessage("buttons", "variant","3")}/>
			<label for="buttons3" className="radio-label">Variant 3</label><br />
			<input type="radio" name="variants-buttons" id="buttons4" onChange={(e) => sendMessage("buttons", "variant","4")}/>
			<label for="buttons4" className="radio-label">Variant 4</label><br />
			<input type="radio" name="variants-buttons" id="buttons5" onChange={(e) => sendMessage("buttons", "variant","5")}/>
			<label for="buttons5" className="radio-label">Variant 5</label><br />
			<input type="radio" name="variants-buttons" id="buttons6" onChange={(e) => sendMessage("buttons", "variant","6")}/>
			<label for="buttons6" className="radio-label">Variant 6</label><br />
			<input type="radio" name="variants-buttons" id="buttons7" onChange={(e) => sendMessage("buttons", "variant","7")}/>
			<label for="buttons7" className="radio-label">Variant 7</label><br />
			<input type="radio" name="variants-buttons" id="buttons8" onChange={(e) => sendMessage("buttons", "variant","8")}/>
			<label for="buttons8" className="radio-label">Variant 8</label><br />
			<input type="radio" name="variants-buttons" id="buttons9" onChange={(e) => sendMessage("buttons", "variant","9")}/>
			<label for="buttons9" className="radio-label">Variant 9</label><br />
			<input type="radio" name="variants-buttons" id="buttons10" onChange={(e) => sendMessage("buttons", "variant","10")}/>
			<label for="buttons10" className="radio-label">Variant 10</label><br />
			<input type="radio" name="variants-buttons" id="buttons11" onChange={(e) => sendMessage("buttons", "variant","11")}/>
			<label for="buttons11" className="radio-label">Variant 11</label><br />
		</div>

		<h2 className="comp-subtitle">Text props</h2>

		<div className="all-text-props">
			<p className="p-prop">button = "BUTTON"</p>
		</div>
		<div className="bottom-div"></div>
	</div>
</div></>
);
}

function sendMessage(id, name, value) {
	let detail = {id:id}; 
	detail[name] = value;
	const event = new CustomEvent("wcfSubcompsService", {detail:detail});
	document.dispatchEvent(event);
}

function compHighlight(e, id) {
	let detail = {id:id}; 
	if (e.target.checked) {
		detail["wcfHighlight"] = "on";
	} else {
		detail["wcfHighlight"] = "off";
	}
	const event = new CustomEvent("wcfSubcompsService", {detail:detail});
	document.dispatchEvent(event);
}

function rotate(e) {
	let detail = {id:"appDemo"}; 
	if (e.target.value == "rows") {
		detail["rows"] = "true";
	} else {
		detail["cols"] = "true";
	}
	const event = new CustomEvent("appDemoService", {detail:detail});
	document.dispatchEvent(event);		
}

function changeWidth(e) {
	let detail = {id:"appDemo"}; 
	detail["contentWidth"] = e.target.value;
	const event = new CustomEvent("appDemoService", {detail:detail});
	document.dispatchEvent(event);		
}

function changeHeight(e) {
	let detail = {id:"appDemo"}; 
	detail["contentHeight"] = e.target.value;
	const event = new CustomEvent("appDemoService", {detail:detail});
	document.dispatchEvent(event);		
}

function toggleTexts(e) {
	let detail;
	let event;
	if (e.target.checked) {
		detail = {id:"buttons"};
		detail["button"] = " ";
		event = new CustomEvent("wcfSubcompsService", {detail:detail});
		document.dispatchEvent(event);

	} else {
		detail = {id:"buttons"};
		detail["button"] = "BUTTON";
		event = new CustomEvent("wcfSubcompsService", {detail:detail});
		document.dispatchEvent(event);

	}

}

function toggleImages(e) {
	let detail;
	let event;
	if (e.target.checked) {
	} else {
	}

}

