import { Component, model, SimpleChanges, OnInit, ElementRef  } from "@angular/core";
import { CommonModule } from "@angular/common";
import { WcfSubcomps } from "../wcf-subcomps/wcf-subcomps.service";
import { Subscription } from "rxjs";

@Component({
	selector: "comp-buttons",
	standalone: true,
	imports: [CommonModule],
	templateUrl: "./buttons.component.html",
	styleUrl: "./buttons.component.css"
})

export class Buttons {
	id = model<string>("");
	defaultTexts = model<string>("off");
	defaultImages = model<string>("off");
	wcfHighlight:boolean = false;		// for debugging purpose

	variant = model<string>("0");

	/* Input bindings for text */
	button = model<string>(" ");



	wcfSubcompsSubscription: Subscription;

	constructor(private wcfSubcompsService: WcfSubcomps, private elem: ElementRef) {
		this.wcfSubcompsSubscription = Subscription.EMPTY;
	}

	ngOnInit() {
		this.wcfSubcompsSubscription = this.wcfSubcompsService.attributes.subscribe(attrData => this.changeAttr(attrData));
		this.wcfSubcompsService.changeAttribute({"id":this.id(), "hasBeenRendered":"true"});

		if (this.defaultTexts() == "on") {
			this.button.update((a) => a === " " ? "BUTTON" : a);
		}
	}

	ngOnDestroy() {
		this.wcfSubcompsService.changeAttribute({"id":this.id(), "hasBeenRendered":"false"});
		this.wcfSubcompsSubscription.unsubscribe();
	}

	changeAttr(attrData:any) {
		if (attrData.id && attrData.id == this.id()) {
			if (attrData.hasOwnProperty("variant")) {
				this.variant.set(attrData.variant);
			}
			if (attrData.hasOwnProperty("button")) {
				this.button.set(attrData.button);
			}
			if (attrData.hasOwnProperty("wcfHighlight")) {			// for debugging prupose
				this.wcfHighlight = attrData.wcfHighlight;
			}
		}
	}

	/* if component has custom TypeScript for export class, it goes here */
}

